#ifdef _WIN32
#include "StdAfx.h"
#include <io.h>
#endif
#ifdef __unix__
#include <unistd.h>
#endif
#include "sqpplusrunner.h"

/*
  main
*/
#ifdef _WIN32

CWinApp theApp;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
   // initialize MFC and print and error on failure
   if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
   {
      // TODO: change error code to suit your needs
      _tprintf(_T("Fatal Error: MFC initialization failed\n"));
      return 1;
   }
#else
int main(int argc, char ** argv)
{
#endif
   FILE* pOutFile;
   SQPBatchRunner oSQPRunner;

   if (argc == 1)
   {
      fprintf(stderr, "%s: Usage:\nsqp USP file [output file]\n"
              "USP file is a SIMCA-P project file\n"
              "output file is a file to write output. "
              "If omitted stdout is used\n", argv[0]);
      return -1;
   }

   if (access(argv[1], 04) != 0)
   {
      fprintf(stderr, "%s: Could not open: %s\n"
              "Make sure that the file is not missing, is a SIMCA-P project "
              "and is readable for your user\n", argv[0], argv[1]);
      return -1;
   }
   SQPBatchRunner_Init(&oSQPRunner, argv[1]);

   if (argc > 2)
   {
      pOutFile = fopen(argv[2], "w");
      if (pOutFile == NULL)
      {
         fprintf(stderr, "%s: Could not open output file: "
                 "%s\nWriting output to standard out\n", argv[0], argv[2]);
      }
      else
      {
         SQPBatchRunner_Run(&oSQPRunner, pOutFile, stderr);
         fclose(pOutFile);
         SQPBatchRunner_Destroy(&oSQPRunner);
         return 0;
      }
   }

   SQPBatchRunner_Run(&oSQPRunner, stdout, stderr);
   SQPBatchRunner_Destroy(&oSQPRunner);

   return 0;
}
